:: (C) Compaq Computer Corp. - Sample script for StorageWorks Virtual Replicator

REM *********************************************************************************
REM	Used to recover to the SNAPSHOT from a corrupt PARENT.
REM	The SNAPSHOT is expected to be the LAST KNOWN GOOD copy. 
REM     ESEFILE will process at around 3GB/min
REM
REM	Note: Script is expecting CPQLE.EXE, ESEFILE.EXE to be 
REM        	in a directory in the System PATH. CPQLEMESS.DLL is required in
REM		the %systemroot%\system directory.     
REM
REM     Requires Exchange 5.5 Service Pack 2 or greater.
REM	ESEFILE and ESEUTIL are available from Microsoft.  ESEFILE is availble 
REM	with Exchange Server 5.5 SP3.  
REM
REM *********************************************************************************

REM *** SETLocal- Modify this section with drive:\path for edb.log 

SET LogLocate=E:\exchsrvr\mdbdata

REM *** Modify this section with drive (no ":") for the priv.edb & pub.edb, 
REM 	The Exchange Bin Location and the EDB.CHK file

SET MDBDrive=G
SET ExchBinLocate=C:\exchsrvr\bin 
SET CHKLocate=c:\exchsrvr\mdbdata

REM *** Modify this section with the desired Parent and SNAPSHOT names:

SET ParentName=vdedb
SET SNAPSHOTName=snapdb1
SET SNAPSHOTDrive=s

REM *** Modify this section with the location (LogLocate) of the database log files.
REM 	Also set directory (CompaqLog) for storing output.

REM *** AnchorLog variable is the last consistent transaction log file. 
REM     Use the LAST CONSISTENT LOG GENERATION: from the output of the CHECKDB utility.
REM     Example:  LAST CONSISTENT LOG GENERATION:EDB00047.log
REM     NOTE: If the AnchorLog variable is equal to edb.log than you must use the next 
REM     older transaction log if it exists.

REM *** The anchor log can also be calculated from the first value in parentheses on
REM     the "Last Consistent" line in the output from eseutil /mh.  Convert from decimal
REM     to hexadecimal. 

REM *********************************************************************************
REM	IMPORTANT: If you cannot locate the anchor log file, do not replay ANY log files
REM	into the database.  If you skip the anchor log file and force replay to begin
REM     using a subsequent log file, you may damage the database. If the anchor log is 
REM	not available a "Point in Time" restoration should be evaluated.
REM *********************************************************************************

SET AnchorLog=edb00002.log

SET LogLocate=e:\exchsrvr\mdbdata
SET CompaqLog=c:\compaq\log
SET RecoverLog=recout.txt
SET WarningLog=warn.txt


REM *********************************************************************************
REM ***	End Modification section: Save the snaprec.cmd file
REM *********************************************************************************

REM *** COMMAND TITLE 
TITLE %0

@echo OFF
REM REM SET echo=ON
@if not "%ECHO%"=="" echo %ECHO%

REM *********************************************************************************
REM  	INTEGRITY CHECK THE SNAPSHOT 
REM *********************************************************************************


md c:\compaq\swvr\log\
net time \\%computername% >> c:\compaq\swvr\log\recover.out

REM *** NOTE: Add variable for EDB name

CPQLE 4 3000 "PROCESS:%0, Start Integrity check of SNAPSHOT:%SNAPSHOTName% %SNAPSHOTDrive%:\exchsrvr\mdbdata\priv.edb"  
esefile.exe /s %SNAPSHOTDrive%:\exchsrvr\mdbdata\priv.edb >> c:\compaq\swvr\log\recover.out
SET EZStatement=esefile.exe /s %SNAPSHOTDrive%:\exchsrvr\mdbdata\priv.edb >> c:\compaq\swvr\log\recover.out
IF %ERRORLEVEL%==1 GOTO EXITonESEfileErr


eseutil /mh %SNAPSHOTDrive%:\exchsrvr\mdbdata\priv.edb > c:\compaq\swvr\log\checkdb.out
checkdb.exe c:\compaq\swvr\log\checkdb.out >> c:\compaq\swvr\log\snap.out
REM Add return code check 
CPQLE 4 3002 "PROCESS:%0, Complete Integrity check of SNAPSHOT:%SNAPSHOTName% %SNAPSHOTDrive%:\exchsrvr\mdbdata\ "  

REM *********************************************************************************
REM  	STOP THE MICROSOFT EXCHANGE INFORMATION STORE AND DEPENDENCIES 
REM *********************************************************************************


net stop MSExchangeIS /y

REM *********************************************************************************
REM  Dump EDB.LOG header and store for input to log verification utility
REM  LOG VERIFICATION TEST - LAST CONSISTENT MUST EXIST, SIGNATURES MATCH EDB, SEQUENTIAL ORDER 
REM *********************************************************************************


eseutil /ml %LogLocate%\edb.log > c:\compaq\swvr\log\dumplog.out
dir %LogLocate%\edb*.log /OD /B >> c:\compaq\swvr\log\dumplog.out

checklog.exe c:\compaq\swvr\log\privedb.out c:\compaq\swvr\log\dumplog.out >> c:\compaq\swvr\log\recover.out
SET Checklogtatement=checklog.exe c:\compaq\swvr\log\privedb.out c:\compaq\swvr\log\dumplog.out >> c:\compaq\swvr\log\recover.out
IF %ERRORLEVEL%==1 GOTO EXITonCheckLogERR


REM *********************************************************************************
REM	Used to verify transaction log signatures and paths to .edb files
REM	The Log Verification tools should be tested and customized for your environment.
REM     The output from these scripts will automate verifcation of log files.	
REM 	Review the KB article "XADM: Making and Restoring Offline Backups" Q237767.
REM *********************************************************************************
REM *********************************************************************************
REM *** Housekeeping Section
REM *********************************************************************************

REM * Cleanup old cmp compare files
DEL %CompaqLog%\*.cmp

CD /D %LogLocate%
MD c:\compaq\log

REM  ############################################################################
REM  # DUMP EDB SIGNATURE FROM Transaction Anchor Log 
REM  ############################################################################

FOR %%A IN (edb*.log) DO eseutil /ml %%A | FIND /I "SIG" >%CompaqLog%\%%A.cmp
eseutil /ml %AnchorLog% | find /I "SIG" >%CompaqLog%\%RecoverLog% 

echo ############################################################################>>%CompaqLog%\%RecoverLog% 
echo # START SIGNATURE COMPARE VERIFICATION ***** ANCHOR LOG=%AnchorLog% >>%CompaqLog%\%RecoverLog% 
echo # NOTE: ***** %CompaqLog%\\%AnchorLog%.cmp >>%CompaqLog%\%RecoverLog% 
echo # THE ABOVE LINE INDICATES THE SIGNATURES DID NOT MATCH >>%CompaqLog%\%RecoverLog% 
echo # IF THIS IS EDB00001.LOG THAN IGNORE ELSE YOU MUST INVESTIGATE DIFFERENCES. >>%CompaqLog%\%RecoverLog% 
echo ############################################################################>>%CompaqLog%\%RecoverLog% 

FOR %%A IN (%CompaqLog%\*.cmp) DO FC %CompaqLog%\%AnchorLog%.cmp %%A >>%CompaqLog%\%RecoverLog% 

REM ############################################################################
REM # DUMP EDB PATH FROM Transaction Anchor Log 
REM ############################################################################

FOR %%A IN (edb*.log) DO eseutil /ml %%A | FIND /I ".EDB" >%CompaqLog%\%%A.cmp
eseutil /ml %AnchorLog% | FIND /I ".EDB" >>%CompaqLog%\%RecoverLog% 

echo ############################################################################>>%CompaqLog%\%RecoverLog% 
echo # START PATH COMPARE VERIFICATION ***** ANCHOR LOG=%AnchorLog% >>%CompaqLog%\%RecoverLog% 
echo # NOTE: ***** %CompaqLog%\\%AnchorLog%.cmp >>%CompaqLog%\%RecoverLog% 
echo # THE ABOVE LINE INDICATES THE EDB PATH DID NOT MATCH >>%CompaqLog%\%RecoverLog% 
echo # IF THIS IS EDB00001.LOG THAN IGNORE ELSE YOU MUST INVESTIGATE DIFFERENCES. >>%CompaqLog%\%RecoverLog% 
echo ############################################################################>>%CompaqLog%\%RecoverLog% 

FOR %%A IN (%CompaqLog%\*.cmp) DO FC %CompaqLog%\%AnchorLog%.cmp %%A >>%CompaqLog%\%RecoverLog% 

echo ############################################################################>%CompaqLog%\%WarningLog% 
echo # WARNING !!! IF SIGNATURES OR EDB PATHS DO NOT MATCH THE ANCHOR LOG >>%CompaqLog%\%WarningLog% 
echo # YOU MUST INVESTIGATE WHY.  READ Q237767 FOR MORE INFORMATION. >>%CompaqLog%\%WarningLog% 
echo # "<http://support.microsoft.com/support/kb/articles/Q237/7/67.ASP>" >>%CompaqLog%\%WarningLog% 
echo # IF THIS IS EDB00001.LOG THAN IGNORE ELSE YOU MUST INVESTIGATE EACH TRANSACTION LOG BELOW. >>%CompaqLog%\%WarningLog% 
echo ############################################################################>>%CompaqLog%\%WarningLog% 

FIND /I "*****" %CompaqLog%\%RecoverLog% >>%CompaqLog%\%WarningLog%  

start notepad %CompaqLog%\%WarningLog%  
start notepad %CompaqLog%\%RecoverLog%  


REM *********************************************************************************
REM USER INTERACTION REQUIRED TO CONTINUE
REM *********************************************************************************
CLS
color 47
echo  !!!! VERIFY LOGTEST OUTPUT  !!!
pause
echo  !!!! WARNING Pressing any key will replay the log files !!!!
pause 


REM *********************************************************************************
REM 	UNMAP THE PARENT VIRTUAL DISK 
REM *********************************************************************************

Snapmgr virtual %ParentName% /unmap  >> c:\compaq\swvr\log\recover.out
IF %ERRORLEVEL%==1 GOTO EXITonSnapERR
SET SnapStatement=Snapmgr virtual %ParentName% /unmap  >> c:\compaq\swvr\log\recover.out
CPQLE 4 3003 "PROCESS:%0, Unmap PARENT:%ParentName% complete.  COMMAND:Snapmgr virtual %ParentName% /unmap"

Snapmgr snap %SNAPSHOTName% /unmap >> c:\compaq\swvr\log\recover.out
CPQLE 4 3004 "PROCESS:%0, Unmap SNAPSHOT:%SNAPSHOTName% complete. COMMAND:Snapmgr snap %SNAPSHOTName% /unmap"

REM *********************************************************************************
REM 	MAP %MDBDrive% DRIVELETTER FOR THE SNAPSHOT                                                             
REM *********************************************************************************

Snapmgr snap %SNAPSHOTName% /map:%MDBDrive%  >> c:\compaq\swvr\log\recover.out
CPQLE 4 3005 "PROCESS:%0, PARENT:%ParentName% mapped to the %MDBDrive%: drive.  COMMAND:Snapmgr snap %SNAPSHOTName% /map:%MDBDrive% "

REM *********************************************************************************
REM  	DELETE EDB.CHK  
REM *********************************************************************************

del %CHKLocate%\edb.chk 
CPQLE 4 3006 "PROCESS:%0, %CHKLocate%\edb.chk deleted"

REM *********************************************************************************
REM  	START THE MICROSOFT EXCHANGE SYSTEM ATTENDANT, DIRECTORY SERVICE  
REM *********************************************************************************

Net Start MSExchangeSA
Net Start MSExchangeDS

REM *********************************************************************************
REM  	RUN ISINTEG -PATCH                                                                                              
REM *********************************************************************************

%ExchBinLocate%\isinteg -patch >> c:\compaq\swvr\log\recover.out

REM *********************************************************************************
REM  START THE MICROSOFT EXCHANGE INFORMATION STORE AND DEPENDENCIES 
REM  Note: The Microsoft Exchange Event Service, Key Manager Service, 
REM  Internet Mail Service are dependencies of the Information Store.
REM *********************************************************************************

Net start MSExchangeIS
net start MSExchangeES
net start MSExchangeIMC
net start MSExchangeKMS

net time \\%computername% >> c:\compaq\swvr\log\recover.out

EXIT

REM *********************************************************************************
REM Error Section
REM *********************************************************************************

:EXITonESEfileErr
SET statement3000=The program %0 exited on an ESEFILE error. Please check the parameters of this command: %EZStatement%
CPQLE 1 3000 "%statement3000%"
GOTO END

:EXITonCheckLogERR
SET statement3001=The program %0 exited on a CheckLog.EXE error. Please verify file location and check the parameters of this command: %Checklogtatement%
CPQLE 2 3001 "%statement3001%"
GOTO END

:EXITonSnapERR
SET statement3002=The program %0 exited on an SnapMgr error. Please check the parameters of this command: %SnapStatement%
CPQLE 2 3002 "%statement3002%"
GOTO END

:END
EXIT