<?php

echo "\n// ginkgosnmp included here\n";

$snmpqueue = array();
$snmpdata = array();

/*---- obsoleted - use generic PHP string substitution instead
function SubstituteOID( $oidin )
{
    $oidout = $oidin;

    $oidout = str_replace( "mib2",      ".1.3.6.1.2.1",     $oidout );

    $oidout = str_replace( "compaq",    ".1.3.6.1.4.1.232", $oidout );

    return $oidout;
}
*/

$oid_mib2 = ".1.3.6.1.2.1";

$oid_compaq = ".1.3.6.1.4.1.232";

function QueueSNMP( $jsvarname, $oid, $type, $mode, $columnnames = NULL )
{
    global $snmpqueue;

    # fixup the oid
    if( "." != $oid[0] )    $oid = ".$oid";

    if( 'leaf'==$type && ".0" != substr( $oid, -2 ) )   $oid = "$oid.0";

    #if(NULL!=$columnnames)
    #{
    #    echo "//---GSNMP--- $jsvarname columnnames: " . join(",", $columnnames) . "\n";
    #}

    $snmpqueue[ $oid ] =  array( 'name' => $jsvarname,
                                 'type' => $type,
                                 'mode' => $mode,
                                 'cols' => $columnnames );
}

function JustGetSNMPQueue()
{
    global $snmpqueue;

    $sessiondir = $_SERVER['HTTP_HPSMH_SESSIONDIR'];
    $tempfilename = "$sessiondir/" . substr($_SERVER["SCRIPT_URL"], 1 + strrpos($_SERVER["SCRIPT_URL"], '/')) . uniqid(".", true) . time() . ".txt";

    #echo "//--- GSNMP --- $tempfilename\n";
    $fp = fopen( $tempfilename, "w" );

    foreach ($snmpqueue as $key => $value)
    {
        fwrite( $fp, $value['name'] . "  " . $key . "  get" . $value['type'] . "  " . $value['mode'] . "\n");

        if(NULL != $value['cols'])
            fwrite( $fp, '>>' . join(',', $value['cols']) . "\n");

        #echo "//---GSNMP---- " . $value['name'] . "  " . $key . "  " . $value['type'] . $value['mode'] . "\n";
    }

    fclose( $fp );

    #--- get the SNMP data
    if("Linux" == PHP_OS)
        $cmd = "../../webapp-data/webagent/csginkgo -f$tempfilename";
    else
        $cmd = "..\\..\\smhutil\\csginkgo.exe -f$tempfilename";

    exec( $cmd, $out );

    #echo "//---GSNMP--- cmd is $cmd\n";
    #echo "//---GSNMP--- csginkgo.exe output:\n//---GSNMP--- " . join("\n//---GSNMP--- ", $out) . "\n";

    echo join( "\n", $out);

    #--- delete the cmd file
    unlink( $tempfilename );

    # clear out the queues for additional calls
    $snmpqueue = array();
}

function GenerateJSfromSNMPQueue()
{
    global $snmpqueue;

    JustGetSNMPQueue();
}

?>
