#!/bin/bash
#
# Name: master.sh
# Copyright: (c)2004,2005 Hewlett-Packard Company
#
# Description: builds the Emulex driver from source, makes
#              edits to the system config files and
#              builds a new initrd
# 
# CD		03/01/05 Initial Devlopment
# CD		06/20/05 Add -m flag so that a kernel directory can be
#                        specified

#
# defines
#

SRCDIR="/opt/hp/hp-lpfc"

#
# functions
#

# prints help message

print_help () {
 echo "Usage: $0 [-h -m module_directory ]"
 echo ""
 echo "-m: kernel module directory to use"
 echo "-h: prints help"
 echo ""
 echo "example: $0 -m 2.4.21-9.ELsmp"
}

# This function reads in command line arguments

read_args () {

 if [ $# -gt 0 ]
 then
 	# check arguments

 	MODULEFLAG=0
 	HELPFLAG=0

 	# parse command line into arguments

 	getopt m:h $* 1>/dev/null 2>/dev/null

 	# check result of parsing

 	if [ $? != 0 ]
 	then
 		echo "Bad argument or missing argument"
 		exit 1
 	fi

 	set -- `getopt m:h $*`

 	while [ $1 != -- ]
 	do
 		case $1 in
			-m) MODULEFLAG=1
		    	    MODULEDIR=$2
		    	    shift;;
			-h) HELPFLAG=1;;
			*) echo "$1 is an illegal argument"
		   	   exit 1;;
 		esac
 		shift   # next flag
 	done

 	shift   # skip --

 	if [ $HELPFLAG -eq 1 ]
 	then
 		print_help
 		exit 0
 	fi

 	# make sure that kernel module directory exist

 	if test ! -d /lib/modules/${MODULEDIR}
 	then
 		echo "/lib/modules/${MODULEDIR} does not exist"
 		exit 1
 	fi

 	# set kernel version to be what MODULEDIR is

 	KERNELVERSION=$MODULEDIR
 else
 	# no command line options were given, so use uname -r to get the kernel
 	# version

 	KERNELVERSION=`uname -r`
 fi
}

#
# Script main
#

# read command line args

read_args $*

cd $SRCDIR

./build_driver -m $KERNELVERSION

if [ $? -ne 0 ]
then
 echo ""
 echo "The driver compilation failed!"
 exit 1
fi

echo ""
./edit_conf

echo ""
./make_initrd $KERNELVERSION

exit 0


