:: (C) Compaq Computer Corp. - Sample script for StorageWorks Virtual Replicator

REM	Note: Script is expecting CPQLE.EXE, ESEUTIL.EXE, and CHECKDB.EXE to be 
REM        	in a directory in the System PATH.  CPQLEMESS.DLL is required in
REM		the %systemroot%\system directory.   
REM
REM     Requires: Exchange 5.5 (Service Pack 2 or greater),
REM		  StorageWorks Virtual Replicator,			
REM		  CPQLE.EXE,CPQLEMESS.DLL,ESEUTIL.EXE,CHECKDB.EXE
REM
REM		  CPQLE, CPQLEMESS, CHECKDB are provide with the SWVR scripts.		
REM		
REM		  ESEFILE and ESEUTIL are available from Microsoft.  ESEFILE is availble 
REM		  with Exchange Server 5.5 SP3.  
REM			
REM
REM *********************************************************************************
REM     Modify this section with drive:\path for edb.log 
REM *********************************************************************************

REM SetLocal variables

SET LogLocate=E:\exchsrvr\mdbdata

REM *** Modify this section with the desired Parent and SNAPSHOT names:

SET ParentName=vdedb
SET SNAPSHOTName=snapdb1
SET SNAPSHOTDrive=S

REM *********************************************************************************
REM	End Modification section: Save the snapcopy.cmd file
REM *********************************************************************************

REM *** COMMAND TITLE 
TITLE %0

@echo OFF
REM SET echo=ON
@if not "%ECHO%"=="" echo %ECHO%

REM *********************************************************************************
REM  	STOP THE MICROSOFT EXCHANGE INFORMATION STORE AND DEPENDENCIES 
REM**********************************************************************************

net stop MSExchangeIS /y
REM IF %ERRORLEVEL%==1 GOTO EXITonESEStopErr


REM *********************************************************************************
REM 	DUMP edb.log header and store for input to log verification (CHECKLOG.EXE) utility 
REM     Note: CHECKLOG.EXE is used in the snaprec.cmd file
REM *********************************************************************************

md c:\compaq\swvr\log\
eseutil /ml %LogLocate%\edb.log > c:\compaq\swvr\log\dumplog.out
dir %LogLocate%\edb*.log /OD /B >> c:\compaq\swvr\log\dumplog.out

REM *********************************************************************************
REM 	UNMAP THE OLD SNAPSHOT AND DELETE                                                                            
REM *********************************************************************************

net time \\%computername% >> c:\compaq\swvr\log\snap.out
Snapmgr snap %SNAPSHOTName% /unmap /delete >> c:\compaq\swvr\log\snap.out
IF %ERRORLEVEL%==0 CPQLE 4 2000 "PROCESS:%0,  Delete old SNAPSHOT Complete.  COMMAND:snapmgr SNAP %SNAPSHOTName%/UNMAP /DELETE "
REM CPQLE 4 2010 "PROCESS:%0,  Snap:%SNAPSHOTName% DID NOT DELETE. "



REM *********************************************************************************
REM 	CREATE THE NEW SNAPSHOT FROM THE VIRTUAL DISK DATABASE FILES             
REM *********************************************************************************

Snapmgr snap %SNAPSHOTName% /parent:%ParentName%  >> c:\compaq\swvr\log\snap.out
CPQLE 4 2001 "PROCESS:%0,   snapmgr SNAP %SNAPSHOTName% /parent:%ParentName%  Create new SNAPSHOT COMPLETE"

REM *********************************************************************************
REM  	START THE MICROSOFT EXCHANGE INFORMATION STORE AND DEPENDENCIES 
REM  	Note: The Microsoft Exchange Event Service, Key Manager Service, Internet
REM   		Mail Service are dependencies of the Information Store
REM *********************************************************************************

net start MSExchangeIS
net start MSExchangeES
net start MSExchangeIMC
net start MSExchangeKMS

REM ********************************************************************************
REM 	MAP A DRIVELETTER FOR THE NEW SNAPSHOT                                                              
REM ********************************************************************************

snapmgr snap %SNAPSHOTName% /map:%SNAPSHOTDrive% >> c:\compaq\swvr\log\snap.out
IF %ERRORLEVEL%==0 CPQLE 4 2002 "PROCESS:%0, SNAPSHOT:%SNAPSHOTName% mapped to the %SNAPSHOTDrive%: drive. COMMAND:snapmgr snap %SNAPSHOTName% /map:%SNAPSHOTDrive%"
net time \\%computername% >> c:\compaq\swvr\log\snap.out

REM ********************************************************************************
REM 	DETERMINE AND STORE LAST CONSISTENT TRANSACTION LOG                                
REM ********************************************************************************

eseutil /mh %SNAPSHOTDrive%:\exchsrvr\mdbdata\priv.edb > c:\compaq\swvr\log\PrivMH.out
REM IF %ERRORLEVEL%==1 CPQLE 2 2011 "PROCESS:%0,  WARNING !!! eseutil /mh %SNAPSHOTDrive%:\exchsrvr\mdbdata\priv.edb NOT SUCCESSFUL "

eseutil /mh %SNAPSHOTDrive%:\exchsrvr\mdbdata\pub.edb > c:\compaq\swvr\log\PubMH.out
REM IF %ERRORLEVEL%==1 CPQLE 2 2012 "PROCESS:%0,  WARNING !!! eseutil /mh %SNAPSHOTDrive%:\exchsrvr\mdbdata\pub.edb NOT SUCCESSFUL "

checkdb.exe c:\compaq\swvr\log\PrivMH.out > c:\compaq\swvr\log\privedb.out 
REM IF %ERRORLEVEL%==1 CPQLE 2 2013 "PROCESS:%0,  WARNING !!! CHECKDB.EXE Integrity check of  %SNAPSHOTDrive%:\exchsrvr\mdbdata\pub.edb NOT SUCCESSFUL "
checkdb.exe c:\compaq\swvr\log\PrivMH.out >> c:\compaq\swvr\log\snap.out 

checkdb.exe c:\compaq\swvr\log\PubMH.out > c:\compaq\swvr\log\Pubedb.out 
REM IF %ERRORLEVEL%==1 CPQLE 2 2014 "PROCESS:%0, WARNING !!! CHECKDB.EXE Integrity check of  %SNAPSHOTDrive%:\exchsrvr\mdbdata\priv.edb NOT SUCCESSFUL "
checkdb.exe c:\compaq\swvr\log\PubMH.out >> c:\compaq\swvr\log\snap.out 

EXIT


REM *********************************************************************************
REM Error Section
REM *********************************************************************************

:EXITonESEStopErr
CPQLE 2 2015 "PROCESS:%0,  WARNING !!! The program %0 exited on an NET STOP MSExchange IS /y error. %EZStatement%"
GOTO END


:END
EXIT